<?php
/**
 * Plugin Name: ESM WhatsApp Widget
 * Description: Show a floating WhatsApp widget on the lower right hand corner of the website
 * Author: Sustainable Growth Experts
 */

use Carbon_Fields\Container;
use Carbon_Fields\Field;

// Register Carbon Fields and create custom fields

add_action( 'carbon_fields_register_fields', 'esm_whatsapp_widget_setup' );
function esm_whatsapp_widget_setup() {
    Container::make( 'theme_options', __( 'WhatsApp Widget' ) )
        ->add_fields( array(
            Field::make( 'checkbox', 'esm_whatsapp_enable', __( 'Enable Widget' ) )
                ->set_option_value( 'yes' ),
            Field::make( 'text', 'esm_whatsapp_number', 'WhatsApp Number' ),
            Field::make( 'text', 'esm_whatsapp_message', 'WhatsApp Message' ),

        ) );
}

add_action( 'after_setup_theme', 'crb_load' );
function crb_load() {
    require_once( 'vendor/autoload.php' );
    \Carbon_Fields\Carbon_Fields::boot();
}

// Output HTML to the footer

add_action('wp_footer', 'esm_render_whatsapp_widget');

function esm_render_whatsapp_widget(){ ?>
    <div class="whatsapp-widget">
        <a target="_blank" href="<?php echo carbon_get_theme_option( 'esm_whatsapp_phone_number_link' ); ?>" class="whatsapp-link">
            <span class="whatsap-icon">
				<span class="circle blinking"></span>
                <svg width="211" height="61" viewBox="0 0 211 61" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M0 30.3573C0 13.5914 13.5914 0 30.3573 0H211V60.7145H30.3573C13.5914 60.7145 0 47.1231 0 30.3573V30.3573Z" fill="black"/>
                <path d="M41.0011 46.7144L40.9908 46.7126H40.9635C35.5194 46.7126 32.0412 44.123 31.699 43.9734L25.2832 45.6489L27.0026 39.3852L26.5937 38.7408C24.8999 36.0325 24 32.9136 24 29.7018C24 14.5916 42.3835 7.03558 53.0218 17.7157C63.6345 28.2841 56.1835 46.7144 41.0011 46.7144Z" fill="#63CF59" stroke="white" stroke-width="1.84943" stroke-linejoin="round"/>
                <path d="M50.0849 33.443C49.597 33.2035 46.9689 32.2059 46.5264 32.0478C45.5328 31.6853 45.8132 31.9904 43.9054 34.143C43.6218 34.4544 43.3397 34.4784 42.8583 34.2628C42.3721 34.0233 40.8111 33.5202 38.9633 31.8913C37.524 30.6218 36.5579 29.0647 36.2726 28.5857C35.7977 27.7776 36.7913 27.6626 37.6958 25.9762C37.8579 25.6409 37.7752 25.3774 37.6553 25.1394C37.5337 24.8999 36.566 22.5524 36.1608 21.6166C35.7718 20.6839 35.3714 20.8021 35.0715 20.8021C34.1379 20.7223 33.4555 20.735 32.8542 21.3515C30.238 24.1845 30.8977 27.1069 33.1362 30.2145C37.5353 35.8869 39.8791 36.9313 44.1648 38.3814C45.3221 38.7439 46.3773 38.6928 47.212 38.5746C48.1424 38.4293 50.0762 37.4232 50.4798 36.2973C50.8931 35.1715 50.8931 34.2373 50.7715 34.0217C50.6516 33.8061 50.5712 33.6586 50.0849 33.443Z" fill="white"/>
                <path d="M75.5879 16.4365L77.3018 23.8545L77.6709 25.9199L78.0488 23.8984L79.5078 16.4365H82.3643L83.9023 23.8545L84.2979 25.9199L84.6934 23.9336L86.4248 16.4365H89.1758L85.5283 29.3916H82.9443L81.3799 21.8154L80.9229 19.3105L80.4658 21.8154L78.9014 29.3916H76.3877L72.7139 16.4365H75.5879Z" fill="white"/>
                <path d="M95.8994 19.5654C96.4912 19.5654 97.0273 19.668 97.5078 19.873C97.9941 20.0781 98.3926 20.3916 98.7031 20.8135C98.9668 21.1709 99.1279 21.54 99.1865 21.9209C99.2451 22.2959 99.2744 22.9111 99.2744 23.7666V29.3916H96.7168V23.5645C96.7168 23.0488 96.6289 22.6328 96.4531 22.3164C96.2246 21.8711 95.791 21.6484 95.1523 21.6484C94.4902 21.6484 93.9863 21.8711 93.6406 22.3164C93.3008 22.7559 93.1309 23.3857 93.1309 24.2061V29.3916H90.6348V16.4805H93.1309V21.0596C93.4941 20.5029 93.9131 20.1162 94.3877 19.8994C94.8682 19.6768 95.3721 19.5654 95.8994 19.5654Z" fill="white"/>
                <path d="M106.903 24.7334C106.745 24.833 106.584 24.915 106.42 24.9795C106.262 25.0381 106.042 25.0938 105.761 25.1465L105.198 25.252C104.671 25.3457 104.293 25.46 104.064 25.5947C103.678 25.8232 103.484 26.1777 103.484 26.6582C103.484 27.0859 103.602 27.3965 103.836 27.5898C104.076 27.7773 104.366 27.8711 104.706 27.8711C105.245 27.8711 105.74 27.7129 106.191 27.3965C106.648 27.0801 106.886 26.5029 106.903 25.665V24.7334ZM105.383 23.5645C105.846 23.5059 106.177 23.4326 106.376 23.3447C106.733 23.1924 106.912 22.9551 106.912 22.6328C106.912 22.2402 106.774 21.9707 106.499 21.8242C106.229 21.6719 105.831 21.5957 105.304 21.5957C104.712 21.5957 104.293 21.7422 104.047 22.0352C103.871 22.252 103.754 22.5449 103.695 22.9141H101.278C101.331 22.0762 101.565 21.3877 101.981 20.8486C102.644 20.0049 103.78 19.583 105.392 19.583C106.44 19.583 107.372 19.791 108.187 20.207C109.001 20.623 109.408 21.4082 109.408 22.5625V26.957C109.408 27.2617 109.414 27.6309 109.426 28.0645C109.443 28.3926 109.493 28.6152 109.575 28.7324C109.657 28.8496 109.78 28.9463 109.944 29.0225V29.3916H107.22C107.144 29.1982 107.091 29.0166 107.062 28.8467C107.032 28.6768 107.009 28.4834 106.991 28.2666C106.646 28.6416 106.247 28.9609 105.796 29.2246C105.257 29.5352 104.647 29.6904 103.968 29.6904C103.101 29.6904 102.383 29.4443 101.814 28.9521C101.252 28.4541 100.971 27.751 100.971 26.8428C100.971 25.665 101.425 24.8125 102.333 24.2852C102.831 23.998 103.563 23.793 104.53 23.6699L105.383 23.5645Z" fill="white"/>
                <path d="M110.656 21.6836V19.8994H111.992V17.2275H114.471V19.8994H116.026V21.6836H114.471V26.7461C114.471 27.1387 114.521 27.3848 114.62 27.4844C114.72 27.5781 115.024 27.625 115.534 27.625C115.61 27.625 115.689 27.625 115.771 27.625C115.859 27.6191 115.944 27.6133 116.026 27.6074V29.4795L114.84 29.5234C113.656 29.5645 112.848 29.3594 112.414 28.9082C112.133 28.6211 111.992 28.1787 111.992 27.5811V21.6836H110.656Z" fill="white"/>
                <path d="M119.586 26.333C119.639 26.7783 119.753 27.0947 119.929 27.2822C120.239 27.6162 120.813 27.7832 121.651 27.7832C122.144 27.7832 122.533 27.71 122.82 27.5635C123.113 27.417 123.26 27.1973 123.26 26.9043C123.26 26.623 123.143 26.4092 122.908 26.2627C122.674 26.1162 121.804 25.8643 120.298 25.5068C119.214 25.2373 118.449 24.9004 118.004 24.4961C117.559 24.0977 117.336 23.5234 117.336 22.7734C117.336 21.8887 117.682 21.1299 118.373 20.4971C119.07 19.8584 120.049 19.5391 121.309 19.5391C122.504 19.5391 123.477 19.7793 124.227 20.2598C124.982 20.7344 125.416 21.5576 125.527 22.7295H123.022C122.987 22.4072 122.896 22.1523 122.75 21.9648C122.475 21.625 122.006 21.4551 121.344 21.4551C120.799 21.4551 120.409 21.54 120.175 21.71C119.946 21.8799 119.832 22.0791 119.832 22.3076C119.832 22.5947 119.955 22.8027 120.201 22.9316C120.447 23.0664 121.317 23.2979 122.812 23.626C123.808 23.8604 124.555 24.2148 125.053 24.6895C125.545 25.1699 125.791 25.7705 125.791 26.4912C125.791 27.4404 125.437 28.2168 124.728 28.8203C124.024 29.418 122.935 29.7168 121.458 29.7168C119.952 29.7168 118.839 29.4004 118.118 28.7676C117.403 28.1289 117.046 27.3174 117.046 26.333H119.586Z" fill="white"/>
                <path d="M145.671 24.6016C145.671 23.8633 145.501 23.21 145.161 22.6416C144.827 22.0732 144.282 21.7891 143.526 21.7891C142.618 21.7891 141.994 22.2197 141.654 23.0811C141.479 23.5381 141.391 24.1182 141.391 24.8213C141.391 25.9346 141.687 26.7168 142.278 27.168C142.63 27.4316 143.046 27.5635 143.526 27.5635C144.224 27.5635 144.754 27.2939 145.117 26.7549C145.486 26.2158 145.671 25.498 145.671 24.6016ZM144.247 19.6006C145.366 19.6006 146.312 20.0137 147.086 20.8398C147.865 21.666 148.255 22.8789 148.255 24.4785C148.255 26.166 147.874 27.4521 147.112 28.3369C146.356 29.2217 145.381 29.6641 144.186 29.6641C143.424 29.6641 142.791 29.4736 142.287 29.0928C142.012 28.8818 141.742 28.5742 141.479 28.1699V33.1621H139V19.8115H141.399V21.2266C141.669 20.8105 141.956 20.4824 142.261 20.2422C142.817 19.8145 143.479 19.6006 144.247 19.6006Z" fill="white"/>
                <path d="M155.916 24.6016C155.916 23.8633 155.746 23.21 155.406 22.6416C155.072 22.0732 154.527 21.7891 153.771 21.7891C152.863 21.7891 152.239 22.2197 151.899 23.0811C151.724 23.5381 151.636 24.1182 151.636 24.8213C151.636 25.9346 151.932 26.7168 152.523 27.168C152.875 27.4316 153.291 27.5635 153.771 27.5635C154.469 27.5635 154.999 27.2939 155.362 26.7549C155.731 26.2158 155.916 25.498 155.916 24.6016ZM154.492 19.6006C155.611 19.6006 156.558 20.0137 157.331 20.8398C158.11 21.666 158.5 22.8789 158.5 24.4785C158.5 26.166 158.119 27.4521 157.357 28.3369C156.602 29.2217 155.626 29.6641 154.431 29.6641C153.669 29.6641 153.036 29.4736 152.532 29.0928C152.257 28.8818 151.987 28.5742 151.724 28.1699V33.1621H149.245V19.8115H151.645V21.2266C151.914 20.8105 152.201 20.4824 152.506 20.2422C153.062 19.8145 153.725 19.6006 154.492 19.6006Z" fill="white"/>
                <path d="M164.894 16.4365H167.645V24.3994C167.645 25.29 167.75 25.9404 167.961 26.3506C168.289 27.0771 169.004 27.4404 170.105 27.4404C171.201 27.4404 171.913 27.0771 172.241 26.3506C172.452 25.9404 172.558 25.29 172.558 24.3994V16.4365H175.309V24.3994C175.309 25.7764 175.095 26.8486 174.667 27.6162C173.87 29.0225 172.35 29.7256 170.105 29.7256C167.861 29.7256 166.338 29.0225 165.535 27.6162C165.107 26.8486 164.894 25.7764 164.894 24.3994V16.4365Z" fill="white"/>
                <path d="M179.65 26.333C179.703 26.7783 179.817 27.0947 179.993 27.2822C180.304 27.6162 180.878 27.7832 181.716 27.7832C182.208 27.7832 182.598 27.71 182.885 27.5635C183.178 27.417 183.324 27.1973 183.324 26.9043C183.324 26.623 183.207 26.4092 182.973 26.2627C182.738 26.1162 181.868 25.8643 180.362 25.5068C179.278 25.2373 178.514 24.9004 178.068 24.4961C177.623 24.0977 177.4 23.5234 177.4 22.7734C177.4 21.8887 177.746 21.1299 178.438 20.4971C179.135 19.8584 180.113 19.5391 181.373 19.5391C182.568 19.5391 183.541 19.7793 184.291 20.2598C185.047 20.7344 185.48 21.5576 185.592 22.7295H183.087C183.052 22.4072 182.961 22.1523 182.814 21.9648C182.539 21.625 182.07 21.4551 181.408 21.4551C180.863 21.4551 180.474 21.54 180.239 21.71C180.011 21.8799 179.896 22.0791 179.896 22.3076C179.896 22.5947 180.02 22.8027 180.266 22.9316C180.512 23.0664 181.382 23.2979 182.876 23.626C183.872 23.8604 184.619 24.2148 185.117 24.6895C185.609 25.1699 185.855 25.7705 185.855 26.4912C185.855 27.4404 185.501 28.2168 184.792 28.8203C184.089 29.418 182.999 29.7168 181.522 29.7168C180.017 29.7168 178.903 29.4004 178.183 28.7676C177.468 28.1289 177.11 27.3174 177.11 26.333H179.65Z" fill="white"/>
                <path d="M128.896 29.3916H126L130.412 16.5916H133.894L138.3 29.3916H135.404L132.203 19.5166H132.103L128.896 29.3916ZM128.715 24.3603H135.554V26.4729H128.715V24.3603Z" fill="white"/>
                <path d="M79.1188 38.3053H82.9013V39.0703H79.9348V40.9573H82.6973V41.7223H79.9348V44.3233H79.1188V38.3053Z" fill="#63CF59"/>
                <path d="M87.1021 44.4763C86.6431 44.4763 86.221 44.397 85.8356 44.2383C85.4503 44.074 85.1188 43.8502 84.8411 43.5668C84.5691 43.2835 84.3538 42.9492 84.1951 42.5638C84.0421 42.1785 83.9656 41.762 83.9656 41.3143C83.9656 40.8667 84.0421 40.4502 84.1951 40.0648C84.3538 39.6795 84.5691 39.3452 84.8411 39.0618C85.1188 38.7785 85.4503 38.5575 85.8356 38.3988C86.221 38.2345 86.6431 38.1523 87.1021 38.1523C87.5611 38.1523 87.9833 38.2345 88.3686 38.3988C88.754 38.5575 89.0826 38.7785 89.3546 39.0618C89.6323 39.3452 89.8476 39.6795 90.0006 40.0648C90.1593 40.4502 90.2386 40.8667 90.2386 41.3143C90.2386 41.762 90.1593 42.1785 90.0006 42.5638C89.8476 42.9492 89.6323 43.2835 89.3546 43.5668C89.0826 43.8502 88.754 44.074 88.3686 44.2383C87.9833 44.397 87.5611 44.4763 87.1021 44.4763ZM87.1021 43.7113C87.4478 43.7113 87.7595 43.649 88.0371 43.5243C88.3148 43.394 88.5528 43.2212 88.7511 43.0058C88.9495 42.7905 89.1025 42.5383 89.2101 42.2493C89.3178 41.9547 89.3716 41.643 89.3716 41.3143C89.3716 40.9857 89.3178 40.6768 89.2101 40.3878C89.1025 40.0932 88.9495 39.8382 88.7511 39.6228C88.5528 39.4075 88.3148 39.2375 88.0371 39.1128C87.7595 38.9825 87.4478 38.9173 87.1021 38.9173C86.7565 38.9173 86.4448 38.9825 86.1671 39.1128C85.8895 39.2375 85.6515 39.4075 85.4531 39.6228C85.2548 39.8382 85.1018 40.0932 84.9941 40.3878C84.8865 40.6768 84.8326 40.9857 84.8326 41.3143C84.8326 41.643 84.8865 41.9547 84.9941 42.2493C85.1018 42.5383 85.2548 42.7905 85.4531 43.0058C85.6515 43.2212 85.8895 43.394 86.1671 43.5243C86.4448 43.649 86.7565 43.7113 87.1021 43.7113Z" fill="#63CF59"/>
                <path d="M91.7519 38.3053H93.8684C94.2537 38.3053 94.5711 38.3592 94.8204 38.4668C95.0697 38.5688 95.2652 38.702 95.4069 38.8663C95.5542 39.025 95.6562 39.2063 95.7129 39.4103C95.7696 39.6087 95.7979 39.8013 95.7979 39.9883C95.7979 40.181 95.7639 40.368 95.6959 40.5493C95.6279 40.725 95.5287 40.8865 95.3984 41.0338C95.2737 41.1755 95.1179 41.2973 94.9309 41.3993C94.7496 41.4957 94.5456 41.5552 94.3189 41.5778L96.0274 44.3233H95.0074L93.4774 41.6713H92.5679V44.3233H91.7519V38.3053ZM92.5679 40.9573H93.6389C93.7976 40.9573 93.9534 40.946 94.1064 40.9233C94.2651 40.895 94.4039 40.8468 94.5229 40.7788C94.6476 40.7108 94.7467 40.6145 94.8204 40.4898C94.8941 40.3595 94.9309 40.1923 94.9309 39.9883C94.9309 39.7843 94.8941 39.62 94.8204 39.4953C94.7467 39.365 94.6476 39.2658 94.5229 39.1978C94.4039 39.1298 94.2651 39.0845 94.1064 39.0618C93.9534 39.0335 93.7976 39.0193 93.6389 39.0193H92.5679V40.9573Z" fill="#63CF59"/>
                <path d="M99.9939 38.3053H103.776V39.0703H100.81V40.9573H103.572V41.7223H100.81V44.3233H99.9939V38.3053Z" fill="#63CF59"/>
                <path d="M106.637 38.3053H107.376L109.952 44.3233H109L108.396 42.8358H105.532L104.937 44.3233H103.985L106.637 38.3053ZM108.099 42.1218L106.977 39.3593H106.96L105.821 42.1218H108.099Z" fill="#63CF59"/>
                <path d="M111.253 43.0653C111.401 43.2863 111.588 43.4507 111.814 43.5583C112.047 43.6603 112.285 43.7113 112.528 43.7113C112.664 43.7113 112.803 43.6915 112.945 43.6518C113.086 43.6065 113.214 43.5413 113.327 43.4563C113.446 43.3713 113.543 43.2665 113.616 43.1418C113.69 43.0172 113.727 42.8727 113.727 42.7083C113.727 42.476 113.653 42.3003 113.506 42.1813C113.358 42.0567 113.174 41.9547 112.953 41.8753C112.738 41.7903 112.5 41.711 112.239 41.6373C111.984 41.558 111.746 41.4503 111.525 41.3143C111.31 41.1783 111.129 40.997 110.981 40.7703C110.834 40.538 110.76 40.2263 110.76 39.8353C110.76 39.6597 110.797 39.4727 110.871 39.2743C110.95 39.076 111.072 38.8947 111.236 38.7303C111.401 38.566 111.61 38.43 111.865 38.3223C112.126 38.209 112.438 38.1523 112.8 38.1523C113.129 38.1523 113.443 38.1977 113.744 38.2883C114.044 38.379 114.308 38.5632 114.534 38.8408L113.871 39.4443C113.769 39.2857 113.625 39.1582 113.438 39.0618C113.251 38.9655 113.038 38.9173 112.8 38.9173C112.574 38.9173 112.384 38.9485 112.231 39.0108C112.083 39.0675 111.964 39.144 111.874 39.2403C111.783 39.331 111.718 39.4302 111.678 39.5378C111.644 39.6455 111.627 39.7447 111.627 39.8353C111.627 40.0903 111.701 40.2858 111.848 40.4218C111.996 40.5578 112.177 40.6683 112.392 40.7533C112.613 40.8383 112.851 40.9148 113.106 40.9828C113.367 41.0508 113.605 41.1472 113.82 41.2718C114.041 41.3908 114.225 41.5552 114.373 41.7648C114.52 41.9688 114.594 42.2522 114.594 42.6148C114.594 42.9038 114.537 43.1645 114.424 43.3968C114.316 43.6292 114.169 43.8247 113.982 43.9833C113.795 44.142 113.574 44.2638 113.319 44.3488C113.064 44.4338 112.792 44.4763 112.503 44.4763C112.117 44.4763 111.752 44.4083 111.406 44.2723C111.061 44.1363 110.786 43.9267 110.582 43.6433L111.253 43.0653Z" fill="#63CF59"/>
                <path d="M117.396 39.0703H115.458V38.3053H120.15V39.0703H118.212V44.3233H117.396V39.0703Z" fill="#63CF59"/>
                <path d="M121.359 38.3053H125.243V39.0703H122.175V40.8638H125.031V41.6288H122.175V43.5583H125.396V44.3233H121.359V38.3053Z" fill="#63CF59"/>
                <path d="M126.895 38.3053H129.012C129.397 38.3053 129.714 38.3592 129.964 38.4668C130.213 38.5688 130.408 38.702 130.55 38.8663C130.697 39.025 130.799 39.2063 130.856 39.4103C130.913 39.6087 130.941 39.8013 130.941 39.9883C130.941 40.181 130.907 40.368 130.839 40.5493C130.771 40.725 130.672 40.8865 130.542 41.0338C130.417 41.1755 130.261 41.2973 130.074 41.3993C129.893 41.4957 129.689 41.5552 129.462 41.5778L131.171 44.3233H130.151L128.621 41.6713H127.711V44.3233H126.895V38.3053ZM127.711 40.9573H128.782C128.941 40.9573 129.097 40.946 129.25 40.9233C129.408 40.895 129.547 40.8468 129.666 40.7788C129.791 40.7108 129.89 40.6145 129.964 40.4898C130.037 40.3595 130.074 40.1923 130.074 39.9883C130.074 39.7843 130.037 39.62 129.964 39.4953C129.89 39.365 129.791 39.2658 129.666 39.1978C129.547 39.1298 129.408 39.0845 129.25 39.0618C129.097 39.0335 128.941 39.0193 128.782 39.0193H127.711V40.9573Z" fill="#63CF59"/>
                <path d="M135.137 38.3053H137.254C137.639 38.3053 137.956 38.3592 138.206 38.4668C138.455 38.5688 138.65 38.702 138.792 38.8663C138.939 39.025 139.041 39.2063 139.098 39.4103C139.155 39.6087 139.183 39.8013 139.183 39.9883C139.183 40.181 139.149 40.368 139.081 40.5493C139.013 40.725 138.914 40.8865 138.784 41.0338C138.659 41.1755 138.503 41.2973 138.316 41.3993C138.135 41.4957 137.931 41.5552 137.704 41.5778L139.413 44.3233H138.393L136.863 41.6713H135.953V44.3233H135.137V38.3053ZM135.953 40.9573H137.024C137.183 40.9573 137.339 40.946 137.492 40.9233C137.65 40.895 137.789 40.8468 137.908 40.7788C138.033 40.7108 138.132 40.6145 138.206 40.4898C138.279 40.3595 138.316 40.1923 138.316 39.9883C138.316 39.7843 138.279 39.62 138.206 39.4953C138.132 39.365 138.033 39.2658 137.908 39.1978C137.789 39.1298 137.65 39.0845 137.492 39.0618C137.339 39.0335 137.183 39.0193 137.024 39.0193H135.953V40.9573Z" fill="#63CF59"/>
                <path d="M140.673 38.3053H144.558V39.0703H141.489V40.8638H144.345V41.6288H141.489V43.5583H144.711V44.3233H140.673V38.3053Z" fill="#63CF59"/>
                <path d="M146.388 43.0653C146.536 43.2863 146.723 43.4507 146.949 43.5583C147.182 43.6603 147.42 43.7113 147.663 43.7113C147.799 43.7113 147.938 43.6915 148.08 43.6518C148.221 43.6065 148.349 43.5413 148.462 43.4563C148.581 43.3713 148.678 43.2665 148.751 43.1418C148.825 43.0172 148.862 42.8727 148.862 42.7083C148.862 42.476 148.788 42.3003 148.641 42.1813C148.493 42.0567 148.309 41.9547 148.088 41.8753C147.873 41.7903 147.635 41.711 147.374 41.6373C147.119 41.558 146.881 41.4503 146.66 41.3143C146.445 41.1783 146.264 40.997 146.116 40.7703C145.969 40.538 145.895 40.2263 145.895 39.8353C145.895 39.6597 145.932 39.4727 146.006 39.2743C146.085 39.076 146.207 38.8947 146.371 38.7303C146.536 38.566 146.745 38.43 147 38.3223C147.261 38.209 147.573 38.1523 147.935 38.1523C148.264 38.1523 148.578 38.1977 148.879 38.2883C149.179 38.379 149.443 38.5632 149.669 38.8408L149.006 39.4443C148.904 39.2857 148.76 39.1582 148.573 39.0618C148.386 38.9655 148.173 38.9173 147.935 38.9173C147.709 38.9173 147.519 38.9485 147.366 39.0108C147.218 39.0675 147.099 39.144 147.009 39.2403C146.918 39.331 146.853 39.4302 146.813 39.5378C146.779 39.6455 146.762 39.7447 146.762 39.8353C146.762 40.0903 146.836 40.2858 146.983 40.4218C147.131 40.5578 147.312 40.6683 147.527 40.7533C147.748 40.8383 147.986 40.9148 148.241 40.9828C148.502 41.0508 148.74 41.1472 148.955 41.2718C149.176 41.3908 149.36 41.5552 149.508 41.7648C149.655 41.9688 149.729 42.2522 149.729 42.6148C149.729 42.9038 149.672 43.1645 149.559 43.3968C149.451 43.6292 149.304 43.8247 149.117 43.9833C148.93 44.142 148.709 44.2638 148.454 44.3488C148.199 44.4338 147.927 44.4763 147.638 44.4763C147.252 44.4763 146.887 44.4083 146.541 44.2723C146.196 44.1363 145.921 43.9267 145.717 43.6433L146.388 43.0653Z" fill="#63CF59"/>
                <path d="M151.273 38.3053H153.389C153.775 38.3053 154.092 38.3592 154.341 38.4668C154.591 38.5688 154.786 38.702 154.928 38.8663C155.075 39.025 155.177 39.2063 155.234 39.4103C155.29 39.6087 155.319 39.8013 155.319 39.9883C155.319 40.1753 155.29 40.3708 155.234 40.5748C155.177 40.7732 155.075 40.9545 154.928 41.1188C154.786 41.2775 154.591 41.4107 154.341 41.5183C154.092 41.6203 153.775 41.6713 153.389 41.6713H152.089V44.3233H151.273V38.3053ZM152.089 40.9573H153.16C153.318 40.9573 153.474 40.946 153.627 40.9233C153.786 40.895 153.925 40.8468 154.044 40.7788C154.168 40.7108 154.268 40.6145 154.341 40.4898C154.415 40.3595 154.452 40.1923 154.452 39.9883C154.452 39.7843 154.415 39.62 154.341 39.4953C154.268 39.365 154.168 39.2658 154.044 39.1978C153.925 39.1298 153.786 39.0845 153.627 39.0618C153.474 39.0335 153.318 39.0193 153.16 39.0193H152.089V40.9573Z" fill="#63CF59"/>
                <path d="M159.414 44.4763C158.955 44.4763 158.533 44.397 158.147 44.2383C157.762 44.074 157.431 43.8502 157.153 43.5668C156.881 43.2835 156.666 42.9492 156.507 42.5638C156.354 42.1785 156.277 41.762 156.277 41.3143C156.277 40.8667 156.354 40.4502 156.507 40.0648C156.666 39.6795 156.881 39.3452 157.153 39.0618C157.431 38.7785 157.762 38.5575 158.147 38.3988C158.533 38.2345 158.955 38.1523 159.414 38.1523C159.873 38.1523 160.295 38.2345 160.68 38.3988C161.066 38.5575 161.394 38.7785 161.666 39.0618C161.944 39.3452 162.159 39.6795 162.312 40.0648C162.471 40.4502 162.55 40.8667 162.55 41.3143C162.55 41.762 162.471 42.1785 162.312 42.5638C162.159 42.9492 161.944 43.2835 161.666 43.5668C161.394 43.8502 161.066 44.074 160.68 44.2383C160.295 44.397 159.873 44.4763 159.414 44.4763ZM159.414 43.7113C159.76 43.7113 160.071 43.649 160.349 43.5243C160.627 43.394 160.865 43.2212 161.063 43.0058C161.261 42.7905 161.414 42.5383 161.522 42.2493C161.63 41.9547 161.683 41.643 161.683 41.3143C161.683 40.9857 161.63 40.6768 161.522 40.3878C161.414 40.0932 161.261 39.8382 161.063 39.6228C160.865 39.4075 160.627 39.2375 160.349 39.1128C160.071 38.9825 159.76 38.9173 159.414 38.9173C159.068 38.9173 158.757 38.9825 158.479 39.1128C158.201 39.2375 157.963 39.4075 157.765 39.6228C157.567 39.8382 157.414 40.0932 157.306 40.3878C157.198 40.6768 157.144 40.9857 157.144 41.3143C157.144 41.643 157.198 41.9547 157.306 42.2493C157.414 42.5383 157.567 42.7905 157.765 43.0058C157.963 43.2212 158.201 43.394 158.479 43.5243C158.757 43.649 159.068 43.7113 159.414 43.7113Z" fill="#63CF59"/>
                <path d="M164.064 38.3053H165.135L168.45 43.2523H168.467V38.3053H169.283V44.3233H168.246L164.897 39.3763H164.88V44.3233H164.064V38.3053Z" fill="#63CF59"/>
                <path d="M171.347 43.0653C171.495 43.2863 171.682 43.4507 171.908 43.5583C172.141 43.6603 172.379 43.7113 172.622 43.7113C172.758 43.7113 172.897 43.6915 173.039 43.6518C173.18 43.6065 173.308 43.5413 173.421 43.4563C173.54 43.3713 173.637 43.2665 173.71 43.1418C173.784 43.0172 173.821 42.8727 173.821 42.7083C173.821 42.476 173.747 42.3003 173.6 42.1813C173.452 42.0567 173.268 41.9547 173.047 41.8753C172.832 41.7903 172.594 41.711 172.333 41.6373C172.078 41.558 171.84 41.4503 171.619 41.3143C171.404 41.1783 171.223 40.997 171.075 40.7703C170.928 40.538 170.854 40.2263 170.854 39.8353C170.854 39.6597 170.891 39.4727 170.965 39.2743C171.044 39.076 171.166 38.8947 171.33 38.7303C171.495 38.566 171.704 38.43 171.959 38.3223C172.22 38.209 172.532 38.1523 172.894 38.1523C173.223 38.1523 173.537 38.1977 173.838 38.2883C174.138 38.379 174.402 38.5632 174.628 38.8408L173.965 39.4443C173.863 39.2857 173.719 39.1582 173.532 39.0618C173.345 38.9655 173.132 38.9173 172.894 38.9173C172.668 38.9173 172.478 38.9485 172.325 39.0108C172.177 39.0675 172.058 39.144 171.968 39.2403C171.877 39.331 171.812 39.4302 171.772 39.5378C171.738 39.6455 171.721 39.7447 171.721 39.8353C171.721 40.0903 171.795 40.2858 171.942 40.4218C172.09 40.5578 172.271 40.6683 172.486 40.7533C172.707 40.8383 172.945 40.9148 173.2 40.9828C173.461 41.0508 173.699 41.1472 173.914 41.2718C174.135 41.3908 174.319 41.5552 174.467 41.7648C174.614 41.9688 174.688 42.2522 174.688 42.6148C174.688 42.9038 174.631 43.1645 174.518 43.3968C174.41 43.6292 174.263 43.8247 174.076 43.9833C173.889 44.142 173.668 44.2638 173.413 44.3488C173.158 44.4338 172.886 44.4763 172.597 44.4763C172.211 44.4763 171.846 44.4083 171.5 44.2723C171.155 44.1363 170.88 43.9267 170.676 43.6433L171.347 43.0653Z" fill="#63CF59"/>
                <path d="M176.232 38.3053H180.116V39.0703H177.048V40.8638H179.904V41.6288H177.048V43.5583H180.269V44.3233H176.232V38.3053Z" fill="#63CF59"/>
                </svg>
            </span>
        </a>
    </div>
<?php }


// Enqueue CSS. Add your styling on assets/css/esm-whatsapp-widget-styles.css
add_action('wp_enqueue_scripts', 'esm_enqueue_whatsapp_widget_styles');

function esm_enqueue_whatsapp_widget_styles(){
    wp_enqueue_style('esm-whatsapp-widget-styles', plugin_dir_url(__FILE__) . 'assets/css/esm-whatsapp-widget-styles.css', array(), filemtime(plugin_dir_path(__FILE__) . '/assets/css/esm-whatsapp-widget-styles.css'), false);
}

// Enqueue JS. Add your scripts on assets/js/esm-whatsapp-widget.js
add_action('wp_enqueue_scripts', 'esm_enqueue_whatsapp_widget_scripts');

function esm_enqueue_whatsapp_widget_scripts(){
    wp_enqueue_script( 'esm-whatsapp-widget-script', plugin_dir_url(__FILE__) . 'assets/js/esm-whatsapp-widget.js', array(), '1.0.0', true );
}

